"""
    Créer un programme permettant de gérer une liste de course.
    Le programme doit permettre les actions suivantes :
    ● A = Ajouter un élément à la liste
    ● S = Supprimer un élément à la liste
    ● L = Lister les éléments de la liste et les compter
    ● V = Vider la liste
    ● E = Mettre fin au programme

   > Créer le code pour chaques actions
   > transformer la lsite des actions autorisée en tuple
"""
authorized_actions = ('A', 'S', 'L', 'V', 'E', 'C')
ma_liste = ['pomme', 'poire', 'citron', 'pomme', 'pomme']

while True:
    action = input("\n\nQuelle action souhaitez-vous effectuer ? "
                   "\n(A = ajouter, S = Supprimer, L = Liste, V = vider, C = Check, E = Exit)").upper()

    if not action in authorized_actions:
        print("Nous n'avons pas compris votre demande.")
        continue

    if action == 'E':
        break

    elif action == 'A':
        item = input("Que voulez-vous ajouter ? ")

        if ',' in item:
            new_items = item.split(', ')
            ma_liste += new_items
        else:
            ma_liste.append(item)
        print(ma_liste)

    elif action == 'S':
        item = input("Que voulez-vous supprimer ? ")
        if item not in ma_liste:
            print("Désolé, cet item n'est pas présent dans la liste")
        else:
            ma_liste.remove(item)
        print(ma_liste)

    elif action == 'L':
        nb_item = len(ma_liste)
        print(f"Vous avez {nb_item} article(s) dans vote liste : ")
        for value in ma_liste:
            print(f"- {value}")

    elif action == 'C':
        item = input("Que voulez-vous vérifier ? ")
        nb_item = ma_liste.count(item)

        print(f"il y a {nb_item} {item}(s)")


        if nb_item > 1 :
            for i in range(nb_item - 1):
                ma_liste.remove(item)
        print(ma_liste)

    elif action == 'V':
        ma_liste.clear()
        print(ma_liste)


print("Fin du programme")

