#!/usr/bin/python3

"""
    Créer une calculatrice qui permette de multiplier / additionner / soustraire / diviser 2 nombres
    > le formulaire doit comporter 3 champs : nombre1, nombre2, opérateur
"""

import cgi

form = cgi.FieldStorage()
result = "???"
number1 = number2 = operator = ''

if "number1" in form.keys() and "number2" in form.keys() and "operator" in form.keys():
    number1 = int(form.getvalue("number1"))
    number2 = int(form.getvalue("number2"))
    operator = form.getvalue("operator")

if number1 and number2:
    if operator == "+":
        result = number1 + number2
    if operator == "-":
        result = number1 - number2
    if operator == "x":
        result = number1 * number2
    if operator == "/":
        result = number1 / number2

html = f"""<!DOCTYPE html>
            <head>
                <title>Mon programme</title>
            </head>
            <body>
                <h1>Calculatrice</h1>
                
                <form method="post" action="">
                    <input type="text" name="number1" id="number1" required value={number1}>
                    
                    <select name="operator" id="operator-select">
                        <option value="">--Please choose an option--</option>
                        <option value="+" {'selected' if operator == "+" else ''}>+</option>
                        <option value="-" {'selected' if operator == "-" else ''}>-</option>
                        <option value="x" {'selected' if operator == "x" else ''}>x</option>
                        <option value="/" {'selected' if operator == "/" else ''}>/</option>                        
                    </select>
                    
                    <input type="text" name="number2" id="number2" required value={number2}>
                    
                    <input type="submit" value="Calculer !">
                </form>

                <h2> = {result}</h2>

                
            </body>
            </html>
"""

print("Content-Type: text/html; charset=utf-8\n")
print(html)
