#!/usr/bin/python3
"""
    Créer une page web pour ajouter des éléments dans une liste

    Conseil : créez votre programme en plusieurs étapes.
    Par exemple,
    - commencer par afficher une liste de course toute faite
    - ajouter 1 élément à cette liste de course
    - ...
"""

import cgi
import cgitb

cgitb.enable()

# gestion du formulaire
form = cgi.FieldStorage()

ma_liste = []

# L'item que le user vient d'ajouter dans le formulaire
if "item" in form.keys():
    item = form.getvalue("item")
    ma_liste.append(item)

html_liste = ''
for item in ma_liste:
    html_liste += f"<li>{item}</li>"

# Creation du code source html
html = f"""<!DOCTYPE html>
        <head>
            <meta charset="utf-8">
            <title>Mon programme</title>
        </head>
        <body>
            <h1>Liste de course</h1> 
            <ul>   
            {html_liste}    
            </ul>
            <form method="post" action="">
                <input type="text" name="item">        
                <input type="submit" value="Ajouter">
            </form>
        </body>
        </html>
        """

# Affichage
print("Content-Type: text/html; charset=utf-8\n")
print(html)
