#!/usr/bin/python3
"""
    Créer une page web pour ajouter des éléments dans une liste

    Conseil : créez votre programme en plusieurs étapes.
    Par exemple,
    - commencer par afficher une liste de course toute faite
    - ajouter 1 élément à cette liste de course
    - ...
"""

import cgi
import cgitb

cgitb.enable()

# gestion du formulaire
form = cgi.FieldStorage()


ma_liste = []

# la liste avec tous les ingredients ajoutés jusqu'ici
# (cette liste est présente dans le input hidden)
if "ma_liste_hidden" in form.keys():
    ma_liste_str = form.getvalue("ma_liste_hidden")
    ma_liste = ma_liste_str.split(",")

# L'item que le user vient d'ajouter dans le formulaire
if "item" in form.keys():
    item = form.getvalue("item")
    ma_liste.append(item)

ma_liste_str = ', '.join(ma_liste)

html_liste = "<p>Pas d'element dans la liste</p>"
if ma_liste:
    html_liste = ""
    for item in ma_liste:
        html_liste += f"<li>{item}</li>"


# Creation du code source html
html = f"""<!DOCTYPE html>
        <head>
            <meta charset="utf-8">
            <title>Mon programme</title>
        </head>
        <body>
            <h1>Liste de course</h1> 
            <ul>   
            {html_liste}    
            </ul>
            <form method="post" action="">
                <input type="text" name="item">        
                <input type="hidden" value="{ma_liste_str}" name="ma_liste_hidden">        
                <input type="submit" value="Ajouter">
            </form>
        </body>
        </html>
        """

# Affichage
print("Content-Type: text/html; charset=utf-8\n")
print(html )
