"""
    -- Refacto de l'exercice sur la "liste de course" --

    Ajouter les actions demandés
    A = Ajouter un élément à la liste
    S = Supprimer un élément à la liste
    L = Lister les éléménts de la liste et les compter
    V = Vider la liste
    E = Mettre fin au programme
"""


def add_item(liste):
    """ Ajoute un item à la liste """
    item = input("Que voulez-vous ajouter ? ")    
    if ',' in item:
        list_item = item.split(', ')
        liste += list_item
    else:
        liste.append(item)
    
    return liste


def remove_item(liste):
    """ Supprime un item à la liste """
    item = input("Que voulez-vous supprimer ? ")
    if not item in liste:
        print("Désolé, ce item n'est pas présent dans la liste")
    else:
        liste.remove(item)
    
    return liste


def display_list(liste):
    """ Liste les éléménts de la liste et les compte """
    nb_item = len(liste)
    print(f"Vous avez {nb_item} article(s) dans vote liste : ")
    for value in liste:
        print(value)


def is_authorized(action):
    """ 
    return True si l'action est authorisée, 
    sinon affiche un message d'erreur et return False
    """
    authorized = True
    if not action in AUTHORIZED_ACTIONS:
        print("Nous n'avons pas compris votre demande.")
        authorized = False
    return authorized


def dispatch_action(action, liste):
    """
        Fonction qui lance la fonction adequat selon l'action
    """
    if action == 'A':
        liste = add_item(liste)

    elif action == 'S':
        liste = remove_item(liste)

    elif action == 'L':
        display_list(liste)

    elif action == 'V':
        liste.clear()

    return liste





