#!/usr/bin/python3
import cgi
import qrcode

audio_list = None
html_lecteurs_musique = html_qr_code = ""
qr_path = "qr/playlist.png"                                 # chemin où enregistrer le qrcode généré
playlist_link = ""                                          # lien vers la playlist générée

#On regarde si l'utilisateur à checker des cases à cocher
form = cgi.FieldStorage()

if "audio" in form.keys():
    audio_list = form.getvalue("audio")

    # on génère le lien vers la playlist :
    params = ""
    for i in audio_list:
        params += f"&track={i}"
    playlist_link = f'playlist.py?{params}'

    # On génère le QRCode en précisant le lien ves lequel il doit renvoyer
    img = qrcode.make(playlist_link)
    img.save(qr_path)

# Si un lien vers une playlist existe, alors on créé le code html qui correspond
if playlist_link:
    html_qr_code = f'<a href="{playlist_link}"><img src="{qr_path}" title="Playlist"></a>'


# on créé le code html pour afficher les lecteurs de musique. OnN décide d'en afficher 15
for i in range(1, 16):
    track_number = i
    if i < 10:
        track_number = f"0{i}"

    html_lecteurs_musique += f"""<li>
                    {track_number}.mp3
                    <audio controls src="http://mp3.samuelsorin.fr/{track_number}.mp3"></audio>
                    <input type="checkbox" name="audio" value="{i}">
                </li>
    """


# Page HTML finale
html = f"""<!DOCTYPE html>
            <head>
                <title>Mon programme</title>
            </head>
            <body>
                <h1>Generateur de playlist</h1>
                
                { html_qr_code }
                
                <div class="debug">{ audio_list }</div>
                
                <form name="qr-generate">
                    <ul>
                        { html_lecteurs_musique }                                     
                    </ul>
                    <input type="submit" value="Généré ma playlist ! "> 
                </form>
            </body>
        </html>
    """

print("Content-Type: text/html; charset=utf-8\n")
print(html)
