#!/usr/bin/python3
# coding: utf-8

"""
Exercice 1
À partir de votre serveur web, créer une nouvelle page.

- Cette page doit pouvoir générer de l’HTML grâce à la librairie “jinja”
- Passer un nom en paramètre dans votre template HTML, pour afficher “Bonjour <votre_nom>”
- Passer une liste contenant plusieurs items et afficher tous les éléments de cette liste au format :
    <ul>
        <li>item 1<li>
        <li>item 2<li>
        …
    </ul>
"""
from jinja2 import Template

template = Template(""" 
    <!DOCTYPE html> 
    <head> 
        <title>Mon site</title> 
    </head> 
    <body> 
        <h1>Hello World</h1> 
        {{ name }}
        {% if name == "sam" %}
            <h1>Salut !!</h1>
        {% endif %}
        
        <ul>
        {% for ingredient in ma_liste %}
            <li>{{ ingredient }}</li>
        {% endfor %}
        </ul>
    </body> 
    </html> 
""")

liste = ["item 1", "item 2", "item 2"]
print("Content-type: text/html; charset=utf-8\n")
print(template.render(name='sam', ma_liste=liste))
