# -*- coding: utf-8 -*-

from jinja2 import Environment, FileSystemLoader

def render(template, args={}):
    file_loader = FileSystemLoader('templates')
    env = Environment(loader=file_loader)

    template = env.get_template(template)
    output = template.render(args)

    print("Content-type: text/html; charset=utf-8\n")
    print(output)