import qrcode


def create_qrcode_url(audio_list):
    """
        retourne une utl avec les numéros de chanson en paramètre
        exemple : /playlist.py?audio=1&audio=2&audio=10
    """
    tracks_html = ""
    for i in audio_list:
        tracks_html += f"&track={i}"
    return f"playlist.py?{tracks_html}"


def qrcode_generate(url):
    """
    Permet de générer un QR Code à partir d'une url
    puis l'enregistre sur le disque
    return le path où à été enregistré le qrcode
    """
    path = "qr/playlist.png"
    qr_img = qrcode.make(url)
    qr_img.save("qr/playlist.png")

    return path
