from flask import Flask, render_template, redirect, request
from .models import get_liste, clear_list, add_item, remove_item

app = Flask(__name__)


@app.route('/')
def index():
    """
        Page principale de l'application
        Affiche la liste de course ainsi que le formulaire permettant d'ajouter de nouveaux éléments
    """
    items = get_liste()
    return render_template('course.html', items=items)


@app.route('/add/', methods=['POST'])
def add():
    """
        Ajoute un élément à la liste de course puis retourne à la page principale
    """
    item = request.form['item']
    if item:
        add_item(item)
    return redirect("/")


@app.route('/delete/<item>', methods=['GET'])
def delete(item):
    """
        Supprime un élément à la liste de course puis retourne à la page principale
    """
    remove_item(item)
    return redirect("/")


@app.route('/clear', methods=['POST', 'GET'])
def clear():
    """
        Vide la liste de course puis retourne à la page principale
    """
    clear_list()
    return redirect("/")

