CSV_FILE_PATH = "data.csv"


def get_csv_data():
    """ recuperation des element present dans data.csv """

    with open(CSV_FILE_PATH, "r") as fichier:
        data = fichier.read()

    return data


def save_csv_data(data, mode='w'):
    """
    On enregistre les data dans le fichier csv
    """

    # si les data envoyés sont sous forme de list, on transform la liste en string séparé par des ';'
    if type(data) == list:
        data = ';'.join(data)

    # Si il y a plus d'un élement dans le fichier csv, alors on ajoute un ';'
    if mode == 'a':
        csv_data = get_csv_data()
        if len(csv_data) > 1:
            data = f';{data}'

    with open(CSV_FILE_PATH, mode) as fichier:
        fichier.write(data)


def get_liste():
    """
    Génère une liste à partir de données csv
    """
    data = get_csv_data()

    # transforme la chaine de caratère récupérer dans le fichier csv en une liste
    liste = data.split(';')

    # Si il y a un caractère vide dans le fichier csv, on le supprime
    if liste[0] == '':
        liste.pop(0)
    return liste


def remove_item(item):
    """ on supprime un element de la liste """

    # récupère la liste depuis le csv sous forme de liste
    data_list = get_liste()

    # supprime l'item demandé dans la liste
    data_list.remove(item)

    save_csv_data(data_list)


def add_item(item):
    """
        recuperation d'un nouvel item à ajouter à la liste

        :return: [liste] if the item is added
                 False if item already in liste
    """
    save_csv_data(item, 'a')


def clear_list():
    """ vide la liste """
    # on ecrase toutes les données avec ''
    save_csv_data('')
