"""
Utilisation basique de Flask : création de plusieurs pages static
"""

from flask import Flask, request

app = Flask(__name__)


@app.route("/")
def index():
   return """
         <h2>Accueil</h2>
         <p>Aller à la page <a href="/contact">contact</a></p>
         """


@app.route("/toto", methods=['post'])
def toto():
   return """<h2>toto</h2>
  <p>Bienvenue dans la page toto</p>"""


@app.route('/contact', defaults={'username': None})
@app.route("/contact/<username>")
def contact(username):

   return f"""<h2>Contact</h2>
  <p>Bienvenue dans la page contact {username or ''}</p>"""


@app.route("/formulaire", methods=['post', 'get'])
def formulaire():
   titleget = request.args.get("titleget")
   title = request.form.get("title")
   print(request)
   return f"""
   
   
   
   <h2>get : {titleget }</h2>
   <h2>form : {title }</h2>
   
   <form method="post"><input type="text" name="title"><input type="submit"></form>
   
   """

if __name__ == "__main__":
   app.run(debug=True)
