def get_csv_data():
    """ recuperation des element present dans data.csv """

    with open("data.csv", "r") as fichier:
        data = fichier.read()

    return data


def get_liste():
    """
    Génère une liste à partir de données csv
    """
    data = get_csv_data()
    liste = data.split(';')
    # dans le cas où le csv commence par un ;
    if liste[0] == '':
        liste.pop(0)
    return liste


def remove_item(item):
    """ on supprime un element de la liste """
    data = get_liste()
    data.remove(item)
    data = ';'.join(data)

    with open("data.csv", "w") as fichier:
        fichier.write(data)


def add_item(item):
    """
        recuperation d'un nouvel item à ajouter à la liste

        :return: [liste] if the item is added
                 False if item already in liste
    """

    with open("data.csv", "a") as fichier:
        data = get_csv_data()
        if len(data) > 1:
            fichier.write(f';{item}')
        else:
            fichier.write(f'{item}')


def clear_list():
    """ vide la liste """
    with open("data.csv", "w") as fichier:
        pass
