class Voiture:

    CONSO = 5
    KM_AU_COMPTEUR = 0

    def __init__(self, nom, carburant=100, couleur="noire"):
        """
        On initialise notre voiture.
        - On doit obligatoirement lui donner un nom
        - On peut préciser combien d'essence la voiture a. Si on ne précise pas, elle à 100 litres
        - On peut préciser la couleur de la voiture. Si on ne précise pas, elle est noire

        """
        self.nom = nom
        self.carburant = carburant
        self.couleur = couleur
        self._conso_par_km = self.CONSO
        self._km_au_compteur = self.KM_AU_COMPTEUR

    def roule(self, km_parcouru):
        self._km_au_compteur += km_parcouru
        self.carburant -= km_parcouru * (self._conso_par_km/100)
        if self.carburant < 10:
            self.alarme()

    @staticmethod
    def alarme():
        print("BIIIIIIIIIIIIIIIIP")

    @staticmethod
    def klaxon():
        print("Tuut Tuut")

    @property
    def niveau_carburant(self):
        return str(self.carburant) + 'litre(s)'

    def km_parcouru(self):
        return str(self._km_au_compteur) + ' km'

    def recap(self):
        print(f"- {self.nom.upper()} - parcouru : {self.km_parcouru()} // carburant restant : {self.niveau_carburant}")

