from flask import Flask, render_template, request, redirect
from .models import Article, Authors, Category

app = Flask(__name__)


@app.route('/')
@app.route('/articles/')
def article_list():
    category = Category()
    cats = category.all()

    article = Article()
    data = article.all()

    authors = Authors()
    data_authors = authors.all()
    for author in data_authors:
        print(author['name'])

    return render_template('article_list.html', articles=data)


@app.route('/articles/<int:id>/')
def article_detail(id):
    article = Article()
    article = article.get(id)
    return render_template('article_detail.html', article=article)


#  ADMIN #########################################

@app.route('/admin/', methods=['GET'])
@app.route('/admin/articles/', methods=['GET'])
def admin_articles_list():
    articles = Article()
    articles = articles.all()
    return render_template('admin/article_list.html', articles=articles)


@app.route('/admin/articles/<int:id>/', methods=['GET'])
def admin_articles_detail(id):
    article = Article()
    article = article.get(id)
    return render_template('admin/article_form.html', article=article)


@app.route('/admin/articles/add/', methods=['GET', 'POST'])
def admin_articles_add():
    if request.method == 'POST':
        data = {
            'title': request.form['title'],
            'content': request.form['content'],
            'excerpt': request.form['excerpt'],
        }
        article = Article()
        article.add(data)
        return redirect(f"/admin/articles/", code=302)

    return render_template('admin/article_form.html')


@app.route('/admin/articles/<int:id>/change/', methods=['POST'])
def admin_articles_update(id):
    if request.method == 'POST':
        data = {
            'title': request.form['title'],
            'content': request.form['content'],
            'excerpt': request.form['excerpt'],
        }

        article = Article()
        article.update(id, data)

    return redirect(f"/admin/articles/", code=302)


@app.route('/admin/articles/<int:id>/delete/', methods=['POST', 'GET'])
def admin_articles_delete(id):
    article = Article()

    if request.method == 'POST':
        article.delete(id)
        return redirect(f"/admin/articles/", code=302)

    data = article.get(id)
    return render_template('admin/article_delete.html', article=data)
