# -*- coding: utf-8 -*-

import sqlite3
DB_NAME = 'blog.db'


class DataBase:
    _conn = None
    _cursor = None

    def connection(self, sql):
        self._conn = sqlite3.connect(DB_NAME)
        self._conn.row_factory = sqlite3.Row

        self._cursor = self._conn.cursor()
        self._cursor.execute(sql)

    def close(self, commit=False):
        if commit:
            self._conn.commit()
        self._conn.close()

    def fetchall(self, sql):
        self.connection(sql)
        items = self._cursor.fetchall()
        self.close()
        return items

    def fetchone(self, sql):
        self.connection(sql)
        item = self._cursor.fetchone()
        self.close()
        return item

    def execute(self, sql):
        self.connection(sql)
        item = self._cursor.lastrowid
        self.close(commit=True)
        return item


class Model(DataBase):

    fields = []

    def _get_table_name(self):
        return self.__class__.__name__

    def all(self):
        sql = f"SELECT * FROM {self._get_table_name()}"
        return self.fetchall(sql)

    def get(self, id):
        sql = f"SELECT * FROM {self._get_table_name()} where id = {id}"
        return self.fetchone(sql)

    def add(self, data):
        sql_values = []
        sql_cols = []
        for key, value in data.items():
            sql_cols.append(key)
            sql_values.append(value)

        sql = f"""INSERT INTO {self._get_table_name()} {tuple(sql_cols)} VALUES {tuple(sql_values)}"""
        print(sql)
        return self.execute(sql)

    def update(self, id, data):
        sql_set = []
        for key, value in data.items():
            sql_set.append(f'{key}="{value}"')
        sql_set = ','.join(sql_set)

        sql = f"""UPDATE {self._get_table_name()} SET {sql_set} WHERE id = {id}"""
        return self.execute(sql)

    def delete(self, id):
        sql = f"DELETE FROM {self._get_table_name()}  where id = {id}"
        return self.execute(sql)
