from flask import Flask, render_template, request, redirect

from .models import Course


app = Flask(__name__)


@app.route('/')
def index():
    course = Course()
    items = course.all()
    return render_template('course.html', items=items)


@app.route('/delete/<int:id>', methods=['GET'])
def delete(id):
    course = Course()
    course.delete(id=id)
    return redirect("/")


@app.route('/add/', methods=['POST'])
def add():
    if request.method == 'POST':
        course = Course()
        course.create(name=request.form['item'])
    return redirect("/")


@app.route('/clear', methods=['POST'])
def clear():
    """
        Vide la liste de course puis retourne à la page principale
    """
    course = Course()
    items = course.all()
    for item in items:
        course.delete(id=item['id'])
        
    return redirect("/")
