# -*- coding: utf-8 -*-

import sqlite3
DB_NAME = 'course.db'


class DataBase:
    _conn = None
    _cursor = None

    def connection(self, sql):
        self._conn = sqlite3.connect(DB_NAME)
        self._conn.row_factory = sqlite3.Row

        self._cursor = self._conn.cursor()
        self._cursor.execute(sql)

    def close(self, commit=False):
        if commit:
            self._conn.commit()
        self._conn.close()

    def fetchall(self, sql):
        self.connection(sql)
        items = self._cursor.fetchall()
        self.close()
        return items

    def fetchone(self, sql):
        self.connection(sql)
        item = self._cursor.fetchone()
        self.close()
        return item

    def execute(self, sql):
        self.connection(sql)
        item = self._cursor.lastrowid
        self.close(commit=True)
        return item


class Model(DataBase):

    fields = []

    def _get_table_name(self):
        """
        Returns the name of the table associated with the class.

        :return: str - the name of the table
        """
        return self.__class__.__name__.lower()

    def all(self):
        """
        Retrieve all records from the table.

        :return: A list of records from the table.
        """
        sql = f"SELECT * FROM {self._get_table_name()}"
        return self.fetchall(sql)

    def get(self, id):
        """
        Retrieves a row from the database table based on the given id.

        Parameters:
            id (int): The id of the row to retrieve.

        Returns:
            dict: A dictionary representing the retrieved row from the database.

        """
        sql = f"SELECT * FROM {self._get_table_name()} where id = {id}"
        return self.fetchone(sql)

    def create(self, **data):
        """

        Parameters:
            self (class object): The class instance calling the method.
            **data (kwargs): The key-value pairs of data to be inserted into the table.

        Description:
            This method inserts data into the table specified by the class instance using the
            provided key-value pairs.

        Example:
            data = {'column1': 'value1', 'column2': 'value2'}
            create(self, **data)
        """
        sql_cols = sql_values =  ''
        for key, value in data.items():
            print(key, value)
            sql_cols += f"{key}, "
            sql_values += f"'{value}', "

        sql = f"""INSERT INTO {self._get_table_name()} ({sql_cols[:-2]}) VALUES ({sql_values[:-2]})"""
        print(sql)
        return self.execute(sql)

    def update(self, id, data):
        """
        Update method to update data in the database.

        Parameters:
        - id (int): The id of the entry to be updated.
        - data (dict): A dictionary containing the data to be updated, where the keys are the
        column names and the values are the new values.

        Returns:
        - None

        Example usage:
        update(1, {'name': 'John', 'age': 30})

        Note:
        - The method builds an SQL query string using the provided id and data dictionary.
        - The data dictionary should only contain key-value pairs corresponding to the columns in the table.
        - The method calls the execute method to execute the SQL query and update the data in the database.
        """
        sql_set = []
        for key, value in data.items():
            sql_set.append(f'{key}="{value}"')
        sql_set = ','.join(sql_set)

        sql = f"""UPDATE {self._get_table_name()} SET {sql_set} WHERE id = {id}"""
        return self.execute(sql)

    def delete(self, id):
        """
        Delete method

        Deletes a record from the database table based on the given id.

        Parameters:
        - id (int): The id of the record to be deleted.

        Returns:
        - bool: True if the record was successfully deleted, False otherwise.

        """
        sql = f"DELETE FROM {self._get_table_name()}  where id = {id}"
        return self.execute(sql)
